#define STANDARD_SAMPLES 40
#define CLOSEUP_SAMPLES 60

varying vec2 UV;
uniform sampler2D textureSampler;
uniform sampler2D depthSampler;
uniform vec2 screenSize;

float linearize2F(float zoverw) {
	float near = 0.001;
	float far = 1;
	return  1 / ((zoverw * ((far - near) / (-far * near)) + far / (far * near)));
}

//Basic depth sampling from a texture
float depthF(sampler2D sampler, vec2 uv) {
	return linearize2F(texture2D(sampler, uv).r);
}

void main() {
	float d = depthF(depthSampler, UV);
	vec4 color = texture2D(textureSampler, UV);

	if (d < 1000) {
		color *= 1.5;
		color += vec4(0.1);
	}

	gl_FragColor = color;
}