//-----------------------------------------------------------------------------
// Torque Game Engine
//
// Copyright (c) 2001 GarageGames.Com
// Additional codes for Marble Blast Platinum by Matan Weissman
//-----------------------------------------------------------------------------

// you will need to play with these values for balanced game play with marble blast platinum

new MaterialProperty(GrassFrictionMaterial) {
   friction = 1.50;
   restitution = 0.35;
};

new MaterialProperty(TarmacFrictionMaterial) {
   friction = 0.85;
   restitution = 0.9;
};

new MaterialProperty(RugFrictionMaterial) {
   friction = 6;
   restitution = 0.5;
};

new MaterialProperty(IceFrictionMaterial) {
   friction = 0.03;
   restitution = 0.95;
};

new MaterialProperty(CarpetFrictionMaterial) {
   friction = 6;
   restitution = 0.5;
};

new MaterialProperty(SandFrictionMaterial) {
   friction = 4;
   restitution = 0.1;
};

new MaterialProperty(WaterFrictionMaterial) {
   friction = 6;
   restitution = 0;
};

new MaterialProperty(BounceyFrictionMaterial) {
   friction = 0.2;
   restitution = 0;
   force = 15;
};

new MaterialProperty(BackwardsForceMaterial) {
   friction = -1;
   restitution = 1;
};

// two levels used the old mud texture which we don't use thus causing us making this value for its filename

new MaterialProperty(IcyFrictionMaterial) {
   friction = 0.03;
   restitution = 0.95;
};

// added to stop the game from popping an error in the console log that it cannot find the
// material property even though the game runs fine without that minor piece of code
// so these lines of code are an extra to shut the game up and you can remove them if you wish

new MaterialProperty(DefaultMaterial) {
   friction = 1;
   restitution = 1;
   force = 0;
};

// these values are for a balanced game play with mini marble golf

new MaterialProperty(MMGGrassMaterial) {
   friction = 0.9;
   restitution = 0.5;
};

new MaterialProperty(MMGSandMaterial) {
   friction = 6;
   restitution = 0.1;
};

new MaterialProperty(MMGWaterMaterial) {
   friction = 6;
   restitution = 0;
};

// these are the old values

new MaterialProperty(RubberFloorMaterial) {
   friction = 1;
   restitution = 1;
};

new MaterialProperty(BumperMaterial) {
   friction = 0.5;
   restitution = 0;
   force = 15;
};

new MaterialProperty(ButtonMaterial) {
   friction = 1;
   restitution = 1;
};


//
addMaterialMapping( "", DefaultMaterial);

// used for levels in marble blast platinum
addMaterialMapping( "grass" , GrassFrictionMaterial);
addMaterialMapping( "ice1" , IceFrictionMaterial);
addMaterialMapping( "rug" ,    RugFrictionMaterial);
addMaterialMapping( "tarmac" ,    TarmacFrictionMaterial);
addMaterialMapping( "carpet" ,    CarpetFrictionMaterial);
addMaterialMapping( "sand" ,    SandFrictionMaterial);
addMaterialMapping( "water" ,    WaterFrictionMaterial);
addMaterialMapping( "floor_bounce" ,    BounceyFrictionMaterial);
addMaterialMapping( "mbp_chevron_friction" ,    BackwardsForceMaterial);
addMaterialMapping( "mbp_chevron_friction2" ,    BackwardsForceMaterial);
addMaterialMapping( "mbp_chevron_friction3" ,    BackwardsForceMaterial);

// added to stop the game from popping an error in the console log that it cannot find the
// material property even though the game runs fine without that minor piece of code
// so this line of code is an extra to shut the game up and you can remove it if you wish

addMaterialMapping( "stripe_caution", DefaultMaterial);

// the texture which both of the levels used was changed from mud to ice but the filename had to be kept the same
addMaterialMapping( "friction_low" ,     IcyFrictionMaterial);

// used for mini marble golf
addMaterialMapping( "mmg_grass" ,    MMGGrassMaterial);
addMaterialMapping( "mmg_sand" ,    MMGSandMaterial);
addMaterialMapping( "mmg_water" ,    MMGWaterMaterial);

// some part textures from the old game
addMaterialMapping( "bumper-rubber" ,    BumperMaterial);
addMaterialMapping( "triang-side" ,      BumperMaterial);
addMaterialMapping( "triang-top" ,      BumperMaterial);
addMaterialMapping( "pball-round-side" , BumperMaterial);
addMaterialMapping( "pball-round-top" , BumperMaterial);
addMaterialMapping( "pball-round-bottm" , BumperMaterial);
addMaterialMapping( "button" , ButtonMaterial);
