//-----------------------------------------------------------------------------
// Torque Game Engine
// 
// Copyright (c) 2001 GarageGames.Com
// Additional code for Marble Blast Platinum by Matan Weissman and Alex Swanson
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
// Game start / end events sent from the server
//----------------------------------------------------------------------------

function clientCmdGameStart()
{
}

function getBestTimes(%mis)
{
   for(%i = 0; %i < 3; %i++)
   {
      $hs[%i] = $pref::highScores[%mis, %i];
      if($hs[%i] $= "")
      {
         if(MissionInfo.time)
            $hs[%i] = MissionInfo.time @ "\tMatan W.";
         else
            $hs[%i] = "5998999\tMatan W.";
      }
   }
}

function clientCmdGameEnd()
{
   if($playingDemo)
      return;

   getBestTimes($Server::MissionFile);
   $highScoreIndex = "";
   for(%i = 0; %i < 3; %i++)
   {
      if($Game::ScoreTime < getField($hs[%i], 0))
      {
         for(%j = 2; %j > %i; %j--)
         {
            $hs[%j] = $hs[%j - 1];
         }
         $highScoreIndex = %i;
         $hs[%i] = $Game::ScoreTime @ "\t" @ $pref::highScoreName;
         break;
      }
   }
   reformatGameEndText();
   Canvas.pushDialog(EndGameGui);
   if($highScoreIndex !$= "")
   {
      if($highScoreIndex == 0)
         %msgIn = "";
      else if($highScoreIndex == 1)
         %msgIn = " second";
      else
         %msgIn = " third";
      EnterNameText.setText("<just:center><font:Expo:50>Well Done!\n<font:DomCasualD:30>You have the" @ %msgIn @ " top time!");
      Canvas.pushDialog(EnterNameDlg);
      EnterNameEdit.setSelectionRange(0, 100000);
   }
}

function highScoreNameAccept()
{
   Canvas.popDialog(EnterNameDlg);
   for(%i = 0; %i < 3; %i++)
      $pref::highScores[$Server::MissionFile, %i] = $hs[%i];
}

function highScoreNameChanged()
{
   $hs[$highScoreIndex] = $Game::ScoreTime @ "\t" @ $pref::highScoreName;
   reformatGameEndText();
}

function reformatGameEndText()
{
   // Final Score
   %text =
      "<shadow:1:1><tab:240,250>" @
      "<font:Expo:50><color:ffff00>Your Time:\t<color:fff090>" @
      formatTime($Game::ScoreTime) @ "<color:000000><font:Expo:30>\n<just:center>";

   // Qualification time

   if(MissionInfo.UltimateTime && $Game::ScoreTime < MissionInfo.UltimateTime)
   {
   %text = %text @ "<color:000000>" @ ("<font:Verdana:27>You beat the <color:FFDD00>Ultimate<color:000000> Time!");
   }

   else

   if(MissionInfo.goldTime && $Game::ScoreTime < MissionInfo.goldTime)
   {
   %text = %text @ "<color:000000>" @ ("<font:Trebuchet MS:27>You beat the <color:888c8d>Platinum<color:000000> Time!");
   }

   else

   if($Game::Qualified)
   {
   %text = %text @ "<color:000000>" @ ("<font:Trebuchet MS:27>You beat the <color:000000>Par<color:000000> Time!");
   }

   else
   %text = %text @ "<color:d00000>You didn't pass the Par Time!";


   // Basic time info
   %text = %text @
   "\n<just:left><font:Arial:14>\n<lmargin:65><tab:235,245><shadowcolor:ffffff7f><shadow:1:1>";
   if (MissionInfo.time)
   %text = %text @
   "<color:000000>" @
   "<font:DomCasualD:24>Par Time:\t" @
   ($Game::Qualified? "<shadowcolor:ffffff7f><color:000000>": "<shadowcolor:0000007f><color:000000>") @
   formatTime(MissionInfo.time) @ "\n";
   else
   %text = %text @ "<color:000000><font:DomCasualD:24>Par Time:\t\t99:59.99\n";

   if(MissionInfo.goldTime)
   {
   %text = %text @ "<shadowcolor:ffffff7f><color:888c8d><font:DomCasualD:24>Platinum Time:\t<color:888c8d><shadowcolor:0000007f>" @
   formatTime(MissionInfo.goldTime) @ "\n";
   }

   if(MissionInfo.UltimateTime)
   {
   %text = %text @ "<shadowcolor:000000><color:FFDD00><font:DomCasualD:24>Ultimate Time:\t<color:FFDD00><shadowcolor:000000>" @
   formatTime(MissionInfo.UltimateTime) @ "\n";
   }

   %text = %text @
   "<shadowcolor:ffffff7f><color:000000>" @
   "<font:DomCasualD:24>Time Passed:\t" @ formatTime($Game::ElapsedTime) @ "\n" @
   "<font:DomCasualD:24>Clock Bonuses:\t" @ formatTime($Game::BonusTime) @ "\n";
   %text = %text @ "<font:Arial:14>\n<font:DomCasualD:32><color:000000>Top Times:\n";
   for(%i = 0; %i < 3; %i++)
   {
   %time = getField($hs[%i], 0);
   %name = getField($hs[%i], 1);
   %text = %text @ "<shadowcolor:ffffff7f><color:000000><font:DomCasualD:25>" @ %i+1 @ ". " @ %name @ "\t";
   if (%time < MissionInfo.UltimateTime)
   {
   %text = %text @ "<shadowcolor:000000><color:FFDD00>";
   }
   else if (%time < MissionInfo.goldTime)
   {
    %text = %text @ "<shadowcolor:ffffff7f><color:888c8d>";
   }
   %text = %text @ formatTime(%time) @ "\n";
   }
   // Display the end-game screen
   EndGameGuiDescription.setText(%text);
}

//-----------------------------------------------------------------------------

function formatTime(%time)
{
   %isNeg = "\t";
   if (%time < 0)
   {
      %time = -%time;
      %isNeg = "-\t";
   }
   %hundredth = mFloor((%time % 1000) / 10);
   %totalSeconds = mFloor(%time / 1000);
   %seconds = %totalSeconds % 60;
   %minutes = (%totalSeconds - %seconds) / 60;

   %secondsOne   = %seconds % 10;
   %secondsTen   = (%seconds - %secondsOne) / 10;
   %minutesOne   = %minutes % 10;
   %minutesTen   = (%minutes - %minutesOne) / 10;
   %hundredthOne = %hundredth % 10; 
   %hundredthTen = (%hundredth - %hundredthOne) / 10;

   return %isNeg @ %minutesTen @ %minutesOne @ ":" @
       %secondsTen @ %secondsOne @ "." @
       %hundredthTen @ %hundredthOne;
}

//-----------------------------------------------------------------------------

function clientCmdGetEasterEggState()
{
	echo("State: " @ $pref::easterEgg[$Server::MissionFile, %i] );
	commandToServer('EasterEggCheck',$pref::easterEgg[$Server::MissionFile, %i]);
}

function clientCmdSetEasterEggState(%state)
{
	$pref::easterEgg[$Server::MissionFile, %i] = %state;
}
