//-----------------------------------------------------------------------------
// Torque Game Engine
// 
// Copyright (c) 2001 GarageGames.Com
//
// This part is by Matan Weissman for the XBOX 360 Controller with great thanks
// to xboxpro57 and Spy47 who helped me out with this.
// Controller used: Wired Controller which was also modded.
// The button numbers below equal to the following triggers as if:
// gamepadMap.bind(joystick, button3, mouseFire);
// which means powerup activation is done when you press Y button
// 0 is A
// 1 is B
// 2 is X
// 3 is Y
// 4 is left bumper
// 5 is right bumper
// 6 is back
// 7 is start
// 8 is left thumbstick click
// 9 if right thumbstick click
// right and left triggers are NOT MAPPED and they need to be done. No idea how.
//
// The following were determined after many code tests.
//
// Please note where each of them goes in the current code.
// These codes are suited to have the XBOX360 Controller to be as practically the same
// as possible as the keyboard and mouse.
//
// Change values where you want to modify the speed. The ones below are deafults.
//
// moveYAxis and moveXAxis determine marble movement speed across the two axises
// moveYawAxis is camera movement along X axis (left and right)
// movePitchAxis is camera movement along Y axis (up and down)
//
//    if(mAbs(%val) < 0.2)	     // else the marble will roll by itself forwards/backwards. DO NOT TOUCH IT.
// $mv(X)Action = -%val * (1.68);    // increase the value for faster marble speed
// $mvYaw(X)Speed = -%val * (0.1);   // decrease the value for faster camera movement along X axis (Left/Right)
// $mvPitch = (%val - $marblePitch) * 0.4;   // increase the value for faster camera movement along Y axis (Up/Down)
//
//-----------------------------------------------------------------------------

if ( isObject( moveMap ) )
   moveMap.delete();
new ActionMap(moveMap);

if ( isObject( demoMap) )
   demoMap.delete();
new ActionMap(demoMap);

if ( isObject( gamepadMap ) )
   gamepadMap.delete();

new ActionMap(gamepadMap);

demoMap.bindCmd(keyboard, "escape", "", "onDemoPlayDone(true);");

//------------------------------------------------------------------------------
// Non-remapable binds
//------------------------------------------------------------------------------

function escapeFromGame()
{
   if ( $Game::State $= "End")
      return;
   if ( $Server::ServerType $= "SinglePlayer" )  {
      // In single player, we'll pause the game while the dialog box is up.
      pauseGame();
      ExitGameText.setText("<just:center><font:DomCasualD:32>Exit from this Level?");
      Canvas.pushDialog(ExitGameDlg);
   }
   else
      MessageBoxYesNo( "Disconnect", "Disconnect from the server?",
         "disconnect();", "");
}

moveMap.bindCmd(keyboard, "escape", "", "escapeFromGame();");


//------------------------------------------------------------------------------
// Movement Keys
//------------------------------------------------------------------------------

$movementSpeed = 1; // m/s

function setSpeed(%speed)
{
   if(%speed)
      $movementSpeed = %speed;
}

function moveleft(%val)
{
   $mvLeftAction = %val;
}

function moveright(%val)
{
   $mvRightAction = %val;
}

function moveforward(%val)
{
   $mvForwardAction = %val;
}

function movebackward(%val)
{
   $mvBackwardAction = %val;
}

function moveXAxis(%val)
{
   if(mAbs(%val) < 0.2)
      %val = 0;
   if(%val < 0)
   {
      $mvLeftAction = -%val * (1.68);
      $mvRightAction = 0;
   }
   else
   {
      $mvLeftAction = 0;
      $mvRightAction  = %val * (1.68);
   }
}

function moveYAxis(%val)
{
   if(mAbs(%val) < 0.2)
      %val = 0;
   if(%val < 0)
   {
      $mvForwardAction = -%val * (1.68);
      $mvBackwardAction = 0;
   }
   else
   {
      $mvForwardAction = 0;
      $mvBackwardAction  = %val * (1.68);
   }
}

function moveYawAxis(%val)
{
   if(mAbs(%val) < 0.05)
      %val = 0;
   if(%val < 0)
   {
      $mvYawRightSpeed = -%val * (0.1);
      $mvYawLeftSpeed = 0;
   }
   else
   {
      $mvYawRightSpeed = 0;
      $mvYawLeftSpeed = %val * (0.1);
   }
}

function movePitchAxis(%val)
{
   %ival = %val;
   $mvPitch = (%val - $marblePitch) * 0.4;
}

gamepadMap.bind(joystick, xaxis, moveXAxis);
gamepadMap.bind(joystick, yaxis, moveYAxis);
gamepadMap.bind(joystick, rxaxis, moveYawAxis);
gamepadMap.bind(joystick, ryaxis, movePitchAxis);
gamepadMap.bind(joystick, button0, jump);
gamepadMap.bind(joystick, button1, mouseFire);
gamepadMap.bind(joystick, button7, escapeFromGame);

gamepadMap.push();

function moveup(%val)
{
   $mvUpAction = %val;
}

function movedown(%val)
{
   $mvDownAction = %val;
}

function turnLeft( %val )
{
   $mvYawRightSpeed = %val ? $Pref::Input::KeyboardTurnSpeed : 0;
}

function turnRight( %val )
{
   $mvYawLeftSpeed = %val ? $Pref::Input::KeyboardTurnSpeed : 0;
}

function panUp( %val )
{
   $mvPitchDownSpeed = %val ? $Pref::Input::KeyboardTurnSpeed : 0;
}

function panDown( %val )
{
   $mvPitchUpSpeed = %val ? $Pref::Input::KeyboardTurnSpeed : 0;
}

function getMouseAdjustAmount(%val)
{
   // based on a default camera fov of 90'
   return($pref::Input::MouseSensitivity * %val * ($cameraFov / 90) * 0.01);
}

function yaw(%val)
{
   $mvYaw += getMouseAdjustAmount(%val);
}

function pitch(%val)
{
   if($freelooking || $pref::Input::AlwaysFreeLook)
   {
      if($pref::input::InvertYAxis)
         $mvPitch -= getMouseAdjustAmount(%val);
      else
         $mvPitch += getMouseAdjustAmount(%val);
   }
}

function jump(%val)
{
   $mvTriggerCount2++;
}

function freelook(%val)
{
   $freeLooking = %val;
}

moveMap.bind( keyboard, a, moveleft );
moveMap.bind( keyboard, d, moveright );
moveMap.bind( keyboard, w, moveforward );
moveMap.bind( keyboard, s, movebackward );
moveMap.bind( keyboard, space, jump );
moveMap.bind( mouse, xaxis, yaw );
moveMap.bind( mouse, yaxis, pitch );
moveMap.bind(keyboard, up, panUp);
moveMap.bind(keyboard, down, panDown);
moveMap.bind(keyboard, left, turnLeft);
moveMap.bind(keyboard, right, turnRight);


//------------------------------------------------------------------------------
// Mouse Trigger
//------------------------------------------------------------------------------

function mouseFire(%val)
{
   $mvTriggerCount0++;
}

function altTrigger(%val)
{
   $mvTriggerCount1++;
}

moveMap.bind( mouse, button0, mouseFire );
if($platform $= "macos")
   moveMap.bind( keyboard, e, freelook );
else
   moveMap.bind( mouse, button1, freelook );


//------------------------------------------------------------------------------
// Camera & View functions
//------------------------------------------------------------------------------

function toggleCamera(%val)
{
   if (%val && $testCheats)
      commandToServer('ToggleCamera');
}

moveMap.bind(keyboard, "alt c", toggleCamera);

//------------------------------------------------------------------------------
// Helper Functions
//------------------------------------------------------------------------------

function dropCameraAtPlayer(%val)
{
   if (%val && $testCheats)
      commandToServer('dropCameraAtPlayer');
}

function dropPlayerAtCamera(%val)
{
   if (%val && $testCheats)
      commandToServer('DropPlayerAtCamera');
}

moveMap.bind(keyboard, "F8", dropCameraAtPlayer);
moveMap.bind(keyboard, "F7", dropPlayerAtCamera);


//------------------------------------------------------------------------------
// Dubuging Functions
//------------------------------------------------------------------------------

$MFDebugRenderMode = 0;
function cycleDebugRenderMode(%val)
{
   if (!%val)
      return;

   if (getBuildString() $= "Debug")
   {
      if($MFDebugRenderMode == 0)
      {
         // Outline mode, including fonts so no stats
         $MFDebugRenderMode = 1;
         GLEnableOutline(true);
      }
      else if ($MFDebugRenderMode == 1)
      {
         // Interior debug mode
         $MFDebugRenderMode = 2;
         GLEnableOutline(false);
         setInteriorRenderMode(7);
         showInterior();
      }
      else if ($MFDebugRenderMode == 2)
      {
         // Back to normal
         $MFDebugRenderMode = 0;
         setInteriorRenderMode(0);
         GLEnableOutline(false);
         show();
      }
   }
   else
   {
      echo("Debug render modes only available when running a Debug build.");
   }
}

GlobalActionMap.bind(keyboard, "F9", cycleDebugRenderMode);


//------------------------------------------------------------------------------
// Misc.
//------------------------------------------------------------------------------

GlobalActionMap.bind(keyboard, "tilde", toggleConsole);
GlobalActionMap.bindCmd(keyboard, "alt enter", "", "pauseMusic();toggleFullScreen();resumeMusic();");
